/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.validator.annotation.NotBlank;
import io.konik.zugferd.entity.Address;
import io.konik.zugferd.entity.Contact;
import io.konik.zugferd.entity.TaxRegistration;
import io.konik.zugferd.unqualified.ID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="TradePartyType", propOrder={"id", "globalIds", "name", "contact", "address", "taxRegistrations"})
public class TradeParty
implements Serializable {
    @XmlElement(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String id;
    @XmlElement(name="GlobalID")
    private List<ID> globalIds;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="DefinedTradeContact")
    private Contact contact;
    @XmlElement(name="PostalTradeAddress")
    private Address address;
    @XmlElement(name="SpecifiedTaxRegistration")
    private List<TaxRegistration> taxRegistrations;

    @Comfort
    public String getId() {
        return this.id;
    }

    public TradeParty setId(String id) {
        this.id = id;
        return this;
    }

    @Comfort
    public List<ID> getGlobalIds() {
        if (this.globalIds == null) {
            this.globalIds = new ArrayList<ID>();
        }
        return this.globalIds;
    }

    public TradeParty addGlobalId(ID additionalGlobalId) {
        this.getGlobalIds().add(additionalGlobalId);
        return this;
    }

    @Basic
    @NotBlank
    public String getName() {
        return this.name;
    }

    public TradeParty setName(String name) {
        this.name = name;
        return this;
    }

    @Valid
    @Extended
    public Contact getContact() {
        return this.contact;
    }

    public TradeParty setContact(Contact newContact) {
        this.contact = newContact;
        return this;
    }

    @Valid
    public Address getAddress() {
        return this.address;
    }

    public TradeParty setAddress(Address postalAddress) {
        this.address = postalAddress;
        return this;
    }

    @Valid
    public List<TaxRegistration> getTaxRegistrations() {
        if (this.taxRegistrations == null) {
            this.taxRegistrations = new ArrayList<TaxRegistration>();
        }
        return this.taxRegistrations;
    }

    public TradeParty addTaxRegistrations(TaxRegistration ... additionalTaxRegistration) {
        Collections.addAll(this.getTaxRegistrations(), additionalTaxRegistration);
        return this;
    }
}

