/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity.trade;

import io.konik.jaxb.bindable.entity.TradeDeliveryTermsAdapter;
import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.CommonAgreement;
import io.konik.zugferd.entity.ReferencedDocument;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.entity.trade.ReferencedDocumentAdditional;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"buyerReference", "seller", "buyer", "productEndUser", "deliveryTerms", "buyerOrder", "contract", "additional", "customerOrder"})
public class Agreement
implements CommonAgreement<ReferencedDocument, ReferencedDocumentAdditional> {
    private String buyerReference;
    private TradeParty seller;
    private TradeParty buyer;
    private TradeParty productEndUser;
    private String deliveryTerms;
    private ReferencedDocument buyerOrder;
    private ReferencedDocument contract;
    private List<ReferencedDocumentAdditional> additional;
    private ReferencedDocument customerOrder;

    @Comfort
    @XmlElement(name="BuyerReference")
    public String getBuyerReference() {
        return this.buyerReference;
    }

    public Agreement setBuyerReference(String buyerReference) {
        this.buyerReference = buyerReference;
        return this;
    }

    @NotNull
    @Valid
    @Basic
    @XmlElement(name="SellerTradeParty")
    public TradeParty getSeller() {
        return this.seller;
    }

    public Agreement setSeller(TradeParty seller) {
        this.seller = seller;
        return this;
    }

    @Valid
    @Extended
    @XmlElement(name="ProductEndUserTradeParty")
    public TradeParty getProductEndUser() {
        return this.productEndUser;
    }

    public Agreement setProductEndUser(TradeParty productEndUser) {
        this.productEndUser = productEndUser;
        return this;
    }

    @XmlElement(name="BuyerTradeParty")
    public TradeParty getBuyer() {
        return this.buyer;
    }

    public Agreement setBuyer(TradeParty buyer) {
        this.buyer = buyer;
        return this;
    }

    @Extended
    @XmlElement(name="ApplicableTradeDeliveryTerms")
    @XmlJavaTypeAdapter(value=TradeDeliveryTermsAdapter.class)
    public String getDeliveryTerms() {
        return this.deliveryTerms;
    }

    public Agreement setDeliveryTerms(String deliveryTerms) {
        this.deliveryTerms = deliveryTerms;
        return this;
    }

    @Override
    @Comfort
    @XmlElement(name="BuyerOrderReferencedDocument")
    public ReferencedDocument getBuyerOrder() {
        return this.buyerOrder;
    }

    public Agreement setBuyerOrder(ReferencedDocument buyerOrder) {
        this.buyerOrder = buyerOrder;
        return this;
    }

    @Override
    @Comfort
    @XmlElement(name="ContractReferencedDocument")
    public ReferencedDocument getContract() {
        return this.contract;
    }

    public Agreement setContract(ReferencedDocument contract) {
        this.contract = contract;
        return this;
    }

    @Override
    @Extended
    @XmlElement(name="AdditionalReferencedDocument")
    public List<ReferencedDocumentAdditional> getAdditional() {
        if (this.additional == null) {
            this.additional = new ArrayList<ReferencedDocumentAdditional>();
        }
        return this.additional;
    }

    public Agreement addAdditional(ReferencedDocumentAdditional additionalReference) {
        this.getAdditional().add(additionalReference);
        return this;
    }

    @Override
    @Comfort
    @XmlElement(name="CustomerOrderReferencedDocument")
    public ReferencedDocument getCustomerOrder() {
        return this.customerOrder;
    }

    public Agreement setCustomerOrder(ReferencedDocument customerOrder) {
        this.customerOrder = customerOrder;
        return this;
    }
}

