/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity.trade;

import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.CommonDelivery;
import io.konik.zugferd.entity.Consignment;
import io.konik.zugferd.entity.ReferencedDocument;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.unqualified.ZfDate;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"relatedConsignment", "shipTo", "ultimateShipTo", "shipFrom", "actualDelivery", "despatchAdvice", "deliveryNote"})
public class Delivery
extends CommonDelivery<ReferencedDocument> {
    @XmlElement(name="RelatedSupplyChainConsignment")
    private Consignment relatedConsignment;
    @XmlElement(name="ShipFromTradeParty")
    private TradeParty shipFrom;
    @XmlElement(name="DespatchAdviceReferencedDocument")
    private ReferencedDocument despatchAdvice;
    @XmlElement(name="DeliveryNoteReferencedDocument")
    private ReferencedDocument deliveryNote;

    Delivery() {
    }

    public Delivery(ZfDate actualDelivery) {
        this.setActualDelivery(actualDelivery);
    }

    @Valid
    @Extended
    public Consignment getRelatedConsignment() {
        return this.relatedConsignment;
    }

    public Delivery setRelatedConsignment(Consignment relatedConsignment) {
        this.relatedConsignment = relatedConsignment;
        return this;
    }

    @Override
    @Valid
    @Extended
    public TradeParty getShipTo() {
        return super.getShipTo();
    }

    @Override
    @Valid
    @Extended
    public TradeParty getUltimateShipTo() {
        return super.getUltimateShipTo();
    }

    @Valid
    @Extended
    public TradeParty getShipFrom() {
        return this.shipFrom;
    }

    public Delivery setShipFrom(TradeParty shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @Override
    @Valid
    @Extended
    public ReferencedDocument getDespatchAdvice() {
        return this.despatchAdvice;
    }

    public Delivery setDespatchAdvice(ReferencedDocument despatchAdvice) {
        this.despatchAdvice = despatchAdvice;
        return this;
    }

    @Override
    @Valid
    @Comfort
    public ReferencedDocument getDeliveryNote() {
        return this.deliveryNote;
    }

    public Delivery setDeliveryNote(ReferencedDocument deliveryNote) {
        this.deliveryNote = deliveryNote;
        return this;
    }
}

