/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity.trade;

import com.neovisionaries.i18n.CurrencyCode;
import io.konik.jaxb.bindable.entity.AccountingAccountAdapter;
import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.CommonSettlement;
import io.konik.zugferd.entity.LogisticsServiceCharge;
import io.konik.zugferd.entity.PaymentMeans;
import io.konik.zugferd.entity.PaymentTerm;
import io.konik.zugferd.entity.Period;
import io.konik.zugferd.entity.SpecifiedAllowanceCharge;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.entity.trade.MonetarySummation;
import io.konik.zugferd.entity.trade.TradeTax;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"paymentReference", "currency", "invoicee", "payee", "paymentMeans", "tradeTax", "billingPeriod", "allowanceCharge", "serviceCharge", "paymentTerms", "monetarySummation", "costCenter"})
public class Settlement
implements CommonSettlement<TradeTax, MonetarySummation> {
    @XmlElement(name="PaymentReference")
    private String paymentReference;
    @XmlElement(name="InvoiceCurrencyCode")
    private CurrencyCode currency;
    @XmlElement(name="InvoiceeTradeParty")
    private TradeParty invoicee;
    @XmlElement(name="PayeeTradeParty")
    private TradeParty payee;
    @XmlElement(name="SpecifiedTradeSettlementPaymentMeans")
    private List<PaymentMeans> paymentMeans;
    @XmlElement(name="ApplicableTradeTax")
    private List<TradeTax> tradeTax;
    @XmlElement(name="BillingSpecifiedPeriod")
    private Period billingPeriod;
    @XmlElement(name="SpecifiedTradeAllowanceCharge")
    private List<SpecifiedAllowanceCharge> allowanceCharge;
    @XmlElement(name="SpecifiedLogisticsServiceCharge")
    private List<LogisticsServiceCharge> serviceCharge;
    @XmlElement(name="SpecifiedTradePaymentTerms")
    private List<PaymentTerm> paymentTerms;
    @XmlElement(name="SpecifiedTradeSettlementMonetarySummation")
    private MonetarySummation monetarySummation;
    @XmlElement(name="ReceivableSpecifiedTradeAccountingAccount")
    @XmlJavaTypeAdapter(value=AccountingAccountAdapter.class)
    private String costCenter;

    @Basic
    public String getPaymentReference() {
        return this.paymentReference;
    }

    public Settlement setPaymentReference(String referenceText) {
        this.paymentReference = referenceText;
        return this;
    }

    @Basic
    @NotNull
    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public Settlement setCurrency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    @Valid
    @Comfort
    public TradeParty getInvoicee() {
        return this.invoicee;
    }

    public Settlement setInvoicee(TradeParty invoicee) {
        this.invoicee = invoicee;
        return this;
    }

    @Valid
    @Extended
    public TradeParty getPayee() {
        return this.payee;
    }

    public Settlement setPayee(TradeParty payee) {
        this.payee = payee;
        return this;
    }

    @Valid
    public List<PaymentMeans> getPaymentMeans() {
        if (this.paymentMeans == null) {
            this.paymentMeans = new ArrayList<PaymentMeans>();
        }
        return this.paymentMeans;
    }

    public Settlement addPaymentMeans(PaymentMeans newPaymentMethod) {
        this.getPaymentMeans().add(newPaymentMethod);
        return this;
    }

    @Override
    public List<TradeTax> getTradeTax() {
        if (this.tradeTax == null) {
            this.tradeTax = new ArrayList<TradeTax>();
        }
        return this.tradeTax;
    }

    public Settlement addTradeTax(TradeTax additionalTradeTax) {
        this.getTradeTax().add(additionalTradeTax);
        return this;
    }

    @Override
    @Valid
    @Comfort
    public Period getBillingPeriod() {
        return this.billingPeriod;
    }

    public Settlement setBillingPeriod(Period billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    @Comfort
    public List<SpecifiedAllowanceCharge> getAllowanceCharge() {
        if (this.allowanceCharge == null) {
            this.allowanceCharge = new ArrayList<SpecifiedAllowanceCharge>();
        }
        return this.allowanceCharge;
    }

    @Comfort
    public Settlement addAllowanceCharge(SpecifiedAllowanceCharge additionalAllowanceCharge) {
        this.getAllowanceCharge().add(additionalAllowanceCharge);
        return this;
    }

    @Comfort
    public List<LogisticsServiceCharge> getServiceCharge() {
        if (this.serviceCharge == null) {
            this.serviceCharge = new ArrayList<LogisticsServiceCharge>();
        }
        return this.serviceCharge;
    }

    @Comfort
    public Settlement addServiceCharge(LogisticsServiceCharge logisticsServiceCharge) {
        this.getServiceCharge().add(logisticsServiceCharge);
        return this;
    }

    @Comfort
    public List<PaymentTerm> getPaymentTerms() {
        if (this.paymentTerms == null) {
            this.paymentTerms = new ArrayList<PaymentTerm>();
        }
        return this.paymentTerms;
    }

    @Comfort
    public Settlement addPaymentTerm(PaymentTerm additionalPaymentTerm) {
        this.getPaymentTerms().add(additionalPaymentTerm);
        return this;
    }

    @Override
    @Basic
    @Valid
    @NotNull
    public MonetarySummation getMonetarySummation() {
        return this.monetarySummation;
    }

    @Basic
    public Settlement setMonetarySummation(MonetarySummation monetarySummation) {
        this.monetarySummation = monetarySummation;
        return this;
    }

    @Extended
    public String getCostCenter() {
        return this.costCenter;
    }

    public Settlement setCostCenter(String costCenter) {
        this.costCenter = costCenter;
        return this;
    }
}

