/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity.trade;

import io.konik.validator.annotation.NotEmpty;
import io.konik.zugferd.entity.trade.Agreement;
import io.konik.zugferd.entity.trade.Delivery;
import io.konik.zugferd.entity.trade.Settlement;
import io.konik.zugferd.entity.trade.item.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SupplyChainTradeTransactionType", propOrder={"agreement", "delivery", "settlement", "items"})
public class Trade
implements Serializable {
    @XmlElement(name="ApplicableSupplyChainTradeAgreement")
    private Agreement agreement;
    @XmlElement(name="ApplicableSupplyChainTradeDelivery")
    private Delivery delivery;
    @XmlElement(name="ApplicableSupplyChainTradeSettlement")
    private Settlement settlement;
    @XmlElement(name="IncludedSupplyChainTradeLineItem")
    private List<Item> items;

    @Valid
    @NotNull
    public Agreement getAgreement() {
        return this.agreement;
    }

    public Trade setAgreement(Agreement agreement) {
        this.agreement = agreement;
        return this;
    }

    @Valid
    @NotNull
    public Delivery getDelivery() {
        return this.delivery;
    }

    public Trade setDelivery(Delivery delivery) {
        this.delivery = delivery;
        return this;
    }

    @Valid
    @NotNull
    public Settlement getSettlement() {
        return this.settlement;
    }

    public Trade setSettlement(Settlement tradeSettlement) {
        this.settlement = tradeSettlement;
        return this;
    }

    @Valid
    @NotEmpty
    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        return this.items;
    }

    public Trade addItem(Item item) {
        this.getItems().add(item);
        return this;
    }
}

