/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity.trade.item;

import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.CommonAgreement;
import io.konik.zugferd.entity.GrossPrice;
import io.konik.zugferd.entity.Price;
import io.konik.zugferd.entity.trade.item.ReferencedDocumentItem;
import io.konik.zugferd.entity.trade.item.ReferencedDocumentItemAdditional;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"buyerOrder", "contract", "additional", "grossPrice", "netPrice", "customerOrder"})
public class SpecifiedAgreement
implements CommonAgreement<ReferencedDocumentItem, ReferencedDocumentItemAdditional> {
    private ReferencedDocumentItem buyerOrder;
    private ReferencedDocumentItem contract;
    private List<ReferencedDocumentItemAdditional> additional;
    private GrossPrice grossPrice;
    private Price netPrice;
    private ReferencedDocumentItem customerOrder;

    @Override
    @Valid
    @Extended
    @XmlElement(name="BuyerOrderReferencedDocument")
    public ReferencedDocumentItem getBuyerOrder() {
        return this.buyerOrder;
    }

    public SpecifiedAgreement setBuyerOrder(ReferencedDocumentItem buyerOrder) {
        this.buyerOrder = buyerOrder;
        return this;
    }

    @Override
    @Valid
    @Extended
    @XmlElement(name="ContractReferencedDocument")
    public ReferencedDocumentItem getContract() {
        return this.contract;
    }

    @Valid
    @Extended
    public SpecifiedAgreement setContract(ReferencedDocumentItem contract) {
        this.contract = contract;
        return this;
    }

    @Override
    @Valid
    @Extended
    @XmlElement(name="AdditionalReferencedDocument")
    public List<ReferencedDocumentItemAdditional> getAdditional() {
        if (this.additional == null) {
            this.additional = new ArrayList<ReferencedDocumentItemAdditional>();
        }
        return this.additional;
    }

    public SpecifiedAgreement addAdditional(ReferencedDocumentItemAdditional additionalReference) {
        this.getAdditional().add(additionalReference);
        return this;
    }

    @Valid
    @XmlElement(name="GrossPriceProductTradePrice")
    public GrossPrice getGrossPrice() {
        return this.grossPrice;
    }

    public SpecifiedAgreement setGrossPrice(GrossPrice grossPrice) {
        this.grossPrice = grossPrice;
        return this;
    }

    @Valid
    @XmlElement(name="NetPriceProductTradePrice")
    public Price getNetPrice() {
        return this.netPrice;
    }

    public SpecifiedAgreement setNetPrice(Price netPrice) {
        this.netPrice = netPrice;
        return this;
    }

    @Override
    @Valid
    @Extended
    @XmlElement(name="CustomerOrderReferencedDocument")
    public ReferencedDocumentItem getCustomerOrder() {
        return this.customerOrder;
    }

    public SpecifiedAgreement setCustomerOrder(ReferencedDocumentItem customerOrder) {
        this.customerOrder = customerOrder;
        return this;
    }
}

