/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity.trade.item;

import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.CommonDelivery;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.entity.trade.item.ReferencedDocumentItem;
import io.konik.zugferd.unqualified.Quantity;
import io.konik.zugferd.unqualified.ZfDate;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"billed", "chargeFree", "packageQuantity", "shipTo", "ultimateShipTo", "actualDelivery", "despatchAdvice", "receivingAdvice", "deliveryNote"})
public class SpecifiedDelivery
extends CommonDelivery<ReferencedDocumentItem> {
    @XmlElement(name="BilledQuantity")
    private Quantity billed;
    @XmlElement(name="ChargeFreeQuantity")
    private Quantity chargeFree;
    @XmlElement(name="PackageQuantity")
    private Quantity packageQuantity;
    @XmlElement(name="DespatchAdviceReferencedDocument")
    private ReferencedDocumentItem despatchAdvice;
    @XmlElement(name="ReceivingAdviceReferencedDocument")
    private ReferencedDocumentItem receivingAdvice;
    @XmlElement(name="DeliveryNoteReferencedDocument")
    private ReferencedDocumentItem deliveryNote;

    public SpecifiedDelivery() {
    }

    public SpecifiedDelivery(Quantity billed) {
        this.billed = billed;
    }

    public SpecifiedDelivery(Quantity billed, ZfDate actualDelivery) {
        this.billed = billed;
        this.setActualDelivery(actualDelivery);
    }

    @Basic
    @Valid
    @NotNull
    public Quantity getBilled() {
        return this.billed;
    }

    public SpecifiedDelivery setBilled(Quantity billedQuantity) {
        this.billed = billedQuantity;
        return this;
    }

    @Extended
    @Valid
    public Quantity getChargeFree() {
        return this.chargeFree;
    }

    public SpecifiedDelivery setChargeFree(Quantity chargeFree) {
        this.chargeFree = chargeFree;
        return this;
    }

    @Extended
    @Valid
    public Quantity getPackageQuantity() {
        return this.packageQuantity;
    }

    public SpecifiedDelivery setPackageQuantity(Quantity packageQuantity) {
        this.packageQuantity = packageQuantity;
        return this;
    }

    @Override
    @Extended
    @Valid
    public TradeParty getShipTo() {
        return super.getShipTo();
    }

    @Override
    @Extended
    @Valid
    public TradeParty getUltimateShipTo() {
        return super.getUltimateShipTo();
    }

    @Override
    @Extended
    public ZfDate getActualDelivery() {
        return super.getActualDelivery();
    }

    @Override
    @Extended
    @Valid
    public ReferencedDocumentItem getDespatchAdvice() {
        return this.despatchAdvice;
    }

    public SpecifiedDelivery setDespatchAdvice(ReferencedDocumentItem despatchAdvice) {
        this.despatchAdvice = despatchAdvice;
        return this;
    }

    @Extended
    @Valid
    public ReferencedDocumentItem getReceivingAdvice() {
        return this.receivingAdvice;
    }

    public SpecifiedDelivery setReceivingAdvice(ReferencedDocumentItem receivingAdvice) {
        this.receivingAdvice = receivingAdvice;
        return this;
    }

    @Override
    @Extended
    @Valid
    public ReferencedDocumentItem getDeliveryNote() {
        return this.deliveryNote;
    }

    public SpecifiedDelivery setDeliveryNote(ReferencedDocumentItem deliveryNote) {
        this.deliveryNote = deliveryNote;
        return this;
    }
}

