/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.profile;

import io.konik.util.Strings;
import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;

public enum ConformanceLevel {
    BASIC,
    COMFORT,
    EXTENDED;

    private static final String DELIMITER = ":";

    public String toString() {
        return this.name().toLowerCase();
    }

    public static ConformanceLevel extractConformanceLevel(String fullName) {
        if (Strings.isNullOrEmpty(fullName)) {
            throw new EnumConstantNotPresentException(ConformanceLevel.class, fullName);
        }
        String[] tokens = fullName.split(DELIMITER);
        int lastTokenPosition = tokens.length - 1;
        String level = tokens[lastTokenPosition];
        return ConformanceLevel.valueOf(level.toUpperCase());
    }

    public static List<Class<? extends Annotation>> getAnnotations() {
        return Arrays.asList(Basic.class, Comfort.class, Extended.class);
    }
}

