/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.profile;

import io.konik.zugferd.profile.ConformanceLevel;
import io.konik.zugferd.profile.ProfileVersion;
import java.io.Serializable;

public class Profile
implements Serializable {
    private static final String DELIMITER = ":";
    private static final String NS = "urn:ferd:CrossIndustryDocument:invoice:";
    private String namespace;
    private ProfileVersion version;
    private ConformanceLevel conformanceLevel;

    public Profile() {
        this.namespace = NS;
        this.version = ProfileVersion.latestVersion();
    }

    public Profile(ConformanceLevel conformanceLevel) {
        this.namespace = NS;
        this.version = ProfileVersion.latestVersion();
        this.conformanceLevel = conformanceLevel;
    }

    public Profile(String namespace, ProfileVersion version, ConformanceLevel conformanceLevel) {
        this.namespace = namespace;
        this.version = version;
        this.conformanceLevel = conformanceLevel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Profile setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ProfileVersion getVersion() {
        return this.version;
    }

    public Profile setVersion(ProfileVersion version) {
        this.version = version;
        return this;
    }

    public ConformanceLevel getConformanceLevel() {
        return this.conformanceLevel;
    }

    public Profile setConformanceLevel(ConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
        return this;
    }

    public String fullName() {
        return this.namespace + this.version.toString() + DELIMITER + this.conformanceLevel.toString();
    }
}

