/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.profile;

import io.konik.util.Strings;

public enum ProfileVersion {
    RC("rc", "rc"),
    RCE("rce", "rce"),
    V1P0("1p0", "1.0");

    private static final String DELIMITER = ":";
    private final String version;
    private final String versionAlt;

    private ProfileVersion(String version, String versionAlt) {
        this.version = version;
        this.versionAlt = versionAlt;
    }

    public String version() {
        return this.version;
    }

    public String versionAlt() {
        return this.versionAlt;
    }

    public static ProfileVersion latestVersion() {
        return ProfileVersion.values()[ProfileVersion.values().length - 1];
    }

    public static ProfileVersion parse(String version) {
        for (ProfileVersion profileVersion : ProfileVersion.values()) {
            if (!profileVersion.versionAlt().equals(version) && !profileVersion.version().equals(version)) continue;
            return profileVersion;
        }
        throw new EnumConstantNotPresentException(ProfileVersion.class, version);
    }

    public static ProfileVersion extractVersion(String fullName) {
        if (Strings.isNullOrEmpty(fullName)) {
            return null;
        }
        String[] tokens = fullName.split(DELIMITER);
        int versionTokenPosition = tokens.length - 2;
        String version = tokens[versionTokenPosition];
        return ProfileVersion.parse(version);
    }

    public String toString() {
        return this.version();
    }
}

