/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.unece.codes;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="TaxTypeCodeType")
@XmlEnum
public enum TaxCode {
    AAA("Petroleum tax"),
    AAB("Provisional countervailing duty cash"),
    AAC("Provisional countervailing duty bond"),
    AAD("Tobacco tax"),
    AAE("Energy fee"),
    AAF("Coffee tax"),
    AAG("Harmonised sales tax, Canadian"),
    AAH("Quebec sales tax"),
    AAI("Canadian provincial sales tax"),
    AAJ("Tax on replacement part"),
    AAK("Mineral oil tax"),
    AAL("Special tax"),
    ADD("Anti-dumping duty"),
    BOL("Stamp duty (Imposta di Bollo)"),
    CAP("Agricultural levy"),
    CAR("Car tax"),
    COC("Paper consortium tax (Italy)"),
    CST("Commodity specific tax"),
    CUD("Customs duty"),
    CVD("Countervailing duty"),
    ENV("Environmental tax"),
    EXC("Excise duty"),
    EXP("Agricultural export rebate"),
    FET("Federal excise tax"),
    FRE("Free"),
    GCN("General construction tax"),
    GST("Goods and services tax"),
    ILL("Illuminants tax"),
    IMP("Import tax"),
    IND("Individual tax"),
    LAC("Business license fee"),
    LCN("Local construction tax"),
    LDP("Light dues payable"),
    LOC("Local sales tax"),
    LST("Lust tax"),
    MCA("Monetary compensatory amount"),
    MCD("Miscellaneous cash deposit"),
    OTH("Other taxes"),
    PDB("Provisional duty bond"),
    PDC("Provisional duty cash"),
    PRF("Preference duty"),
    SCN("Special construction tax"),
    SSS("Shifted social securities"),
    STT("State/provincial sales tax"),
    SUP("Suspended duty"),
    SUR("Surtax"),
    SWT("Shifted wage tax"),
    TAC("Alcohol mark tax"),
    TOT("Total"),
    TOX("Turnover tax"),
    TTA("Tonnage taxes"),
    VAD("Valuation deposit"),
    VAT("Value added tax"),
    ZF_INSURANCE_TAX("Insurance Tax");

    private final String description;

    private TaxCode(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public static TaxCode getByCode(String description) {
        return TaxCode.valueOf(description);
    }

    public String toString() {
        return "[" + this.getCode() + "] " + this.description;
    }
}

