/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.unece.codes;

public enum UnitOfMeasurement {
    ARTICLE("NAR", "A unit of count defining the number of articles (items)"),
    UNIT("C62", "A unit of count defining the number of pieces"),
    SET("SET", "a number of objects grouped together"),
    PAIR("NPR", "number of pairs"),
    HECTARE("HAR", "Hectare (ha)"),
    HOUR("HUR", "Hour (h)"),
    KILOGRAM("KGM", "Kilogram (kg)"),
    KILOMETER("KMT", "Kilometer (km)"),
    KILOWATT_HOUR("KWH", "Kilowatt hour (kWh)"),
    LUMP_SUM("LS", "lump sum"),
    LITRE("LTR", "Liter (l)"),
    MINUTE("MIN", "Minute (min)"),
    MILLIMETER_SQUARE("MMK", "square millimeter (mm2)"),
    MILLIMETER("MMT", "Millimeter (mm)"),
    METER_SQUARE("MTK", "square meter  (m2)"),
    METER_CUBIC("MTQ", "cubic meter (m3)"),
    METER("MTR", "Meter (m)"),
    SECOND("SEC", "Second (s)"),
    PERCENT("P1", "Percent (%)"),
    TON_METRIC("TNE", "Metric ton (t)"),
    DAY("DAY", "days count"),
    WEEK("WEE", "Week"),
    MONTH("MON", "Month"),
    MILE("SMI", "International Mile");

    private final String description;
    private final String code;

    private UnitOfMeasurement(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static UnitOfMeasurement getByCode(String code) {
        if (code != null) {
            for (UnitOfMeasurement v : UnitOfMeasurement.values()) {
                if (v.getCode().intern() != code.intern()) continue;
                return v;
            }
        }
        return null;
    }

    public String toString() {
        return "[" + this.getCode() + "] " + this.description;
    }
}

