/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.unqualified;

import com.neovisionaries.i18n.CurrencyCode;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="AmountType", propOrder={"value"})
public class Amount
implements Serializable {
    @NotNull
    @XmlValue
    private BigDecimal value;
    @NotNull
    @XmlAttribute(name="currencyID")
    private CurrencyCode currency;

    Amount() {
    }

    public Amount(long value, CurrencyCode currency) {
        this.value = BigDecimal.valueOf(value);
        this.currency = currency;
    }

    public Amount(String value, CurrencyCode currency) {
        this.value = new BigDecimal(value);
        this.currency = currency;
    }

    public Amount(BigDecimal value, CurrencyCode currency) {
        this.value = value;
        this.currency = currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Amount setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public Amount setCurrency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    public String toString() {
        return this.getValue() + " " + this.getCurrency();
    }
}

