/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.unqualified;

import io.konik.jaxb.adapter.QuantityRoundingAdapter;
import io.konik.zugferd.unece.codes.UnitOfMeasurement;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QuantityType", propOrder={"value"})
public class Quantity
implements Serializable {
    @XmlValue
    @XmlJavaTypeAdapter(value=QuantityRoundingAdapter.class)
    private BigDecimal value;
    @XmlAttribute(name="unitCode")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String unitCode;

    public Quantity() {
    }

    public Quantity(int value, String unitCode) {
        this.value = BigDecimal.valueOf(value);
        this.unitCode = unitCode;
    }

    public Quantity(BigDecimal value, String unitCode) {
        this.value = value;
        this.unitCode = unitCode;
    }

    public Quantity(BigDecimal value, UnitOfMeasurement unit) {
        this.value = value;
        this.unitCode = unit != null ? unit.getCode() : null;
    }

    public Quantity(int value, UnitOfMeasurement unit) {
        this.value = BigDecimal.valueOf(value);
        this.unitCode = unit.getCode();
    }

    @NotNull
    public BigDecimal getValue() {
        return this.value;
    }

    public Quantity setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    public UnitOfMeasurement getUnit() {
        return UnitOfMeasurement.getByCode(this.unitCode);
    }

    public void setUnit(UnitOfMeasurement unit) {
        this.unitCode = unit != null ? unit.getCode() : null;
    }

    @Size(min=1, max=3)
    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String newUnitCode) {
        this.unitCode = newUnitCode;
    }
}

