/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.Dtaus;

import de.jost_net.OBanToo.Dtaus.ASatz;
import de.jost_net.OBanToo.Dtaus.CSatz;
import de.jost_net.OBanToo.Dtaus.DtausException;
import de.jost_net.OBanToo.Dtaus.ESatz;
import de.jost_net.OBanToo.Dtaus.LogischeDatei;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class DtausDateiParser {
    private String encoding = "ISO-8859-1";
    private InputStream dtaus;
    private ASatz asatz = null;
    private ESatz esatz = null;
    private Vector<LogischeDatei> logischeDateien;
    private LogischeDatei logdat;
    public static final int SPEZIFIKATIONSKONFORM = 0;
    public static final int UMLAUTUMSETZUNG = 1;
    public static final int HEX00TOSPACE = 2;
    public static final int FALSCHESWAEHRUNGSKENNZEICHENERLAUBT = 4;
    private int toleranz = 0;

    public DtausDateiParser(String filename) throws IOException, DtausException {
        this(new BufferedInputStream(new FileInputStream(filename)), 0);
    }

    public DtausDateiParser(File file) throws IOException, DtausException {
        this(new BufferedInputStream(new FileInputStream(file)), 0);
    }

    public DtausDateiParser(String filename, int toleranz) throws IOException, DtausException {
        this(new BufferedInputStream(new FileInputStream(filename)), toleranz);
    }

    public DtausDateiParser(String filename, int toleranz, String encoding) throws IOException, DtausException {
        this(new BufferedInputStream(new FileInputStream(filename)), toleranz, encoding);
    }

    public DtausDateiParser(InputStream is) throws IOException, DtausException {
        this(is, 0);
    }

    public DtausDateiParser(InputStream is, int toleranz) throws IOException, DtausException {
        this(is, toleranz, null);
    }

    public DtausDateiParser(InputStream is, int toleranz, String encoding) throws IOException, DtausException {
        this.toleranz = toleranz;
        if (encoding != null) {
            this.encoding = encoding;
        }
        this.logischeDateien = new Vector();
        this.dtaus = is;
        while (is.available() > 0) {
            this.asatz = new ASatz(this.lese(), toleranz);
            LogischeDatei logdat = new LogischeDatei(this.asatz);
            CSatz c = this.internNext();
            while (c != null) {
                logdat.addCSatz(c);
                c = this.internNext();
            }
            logdat.setESatz(this.esatz);
            this.logischeDateien.addElement(logdat);
        }
        this.logdat = this.logischeDateien.elementAt(0);
    }

    public int getAnzahlLogischerDateien() {
        return this.logischeDateien.size();
    }

    public void setLogischeDatei(int nr) throws DtausException {
        if (nr > this.logischeDateien.size()) {
            throw new DtausException("Ung\u00fcltige Logische Datei: ", nr + "");
        }
        this.logdat = this.logischeDateien.elementAt(nr - 1);
    }

    public LogischeDatei getLogischeDatei(int nr) {
        return this.logischeDateien.elementAt(nr - 1);
    }

    private CSatz internNext() throws IOException, DtausException {
        String satz = this.lese();
        if (satz != null) {
            if (satz.substring(4, 5).equals("C")) {
                return new CSatz(satz, this.toleranz);
            }
            this.esatz = new ESatz(satz, this.toleranz);
            return null;
        }
        return null;
    }

    public ASatz getASatz() {
        return this.logdat.getASatz();
    }

    public CSatz next() {
        return this.logdat.getNextCSatz();
    }

    public ESatz getESatz() {
        return this.logdat.getESatz();
    }

    private String lese() throws IOException, DtausException {
        byte[] inchar = new byte[4];
        this.dtaus.read(inchar);
        String satzlaenge = new String(inchar, this.encoding);
        inchar = new byte[this.getSatzlaenge(satzlaenge) - 4];
        this.dtaus.read(inchar);
        return satzlaenge + new String(inchar, this.encoding);
    }

    private int getSatzlaenge(String satzlaengenfeld) throws DtausException {
        try {
            int sl = Integer.parseInt(satzlaengenfeld);
            if (sl == 128) {
                return 128;
            }
            if (sl >= 187 && sl <= 245) {
                return 256;
            }
            if (sl >= 274 && sl <= 361) {
                return 384;
            }
            if (sl >= 390 && sl <= 477) {
                return 512;
            }
            if (sl >= 506 && sl <= 593) {
                return 640;
            }
            if (sl >= 622) {
                return 728;
            }
            throw new DtausException("Satzl\u00e4nge fehlerhaft: ", satzlaengenfeld);
        }
        catch (NumberFormatException e) {
            if (satzlaengenfeld == null || satzlaengenfeld.length() == 4) {
                return 4;
            }
            throw new DtausException("Satzl\u00e4nge fehlerhaft: ", satzlaengenfeld);
        }
    }

    public static void main(String[] args) {
        int tol = 0;
        String encoding = null;
        if (args.length < 1 || args.length > 3) {
            System.err.println("Argumente f\u00fcr den Aufruf: dateiname [toleranz] [encoding]\ntoleranz = 0 Spezifikationskonform\ntoleranz = 1 DOS-Umlaute umwandeln\ntoleranz = 2 Zeichencode 00 in Space umwandeln");
            System.exit(1);
        }
        if (args.length >= 2) {
            try {
                tol = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                System.err.println("Ung\u00fcltiges Toleranz-Merkmal");
                System.exit(1);
            }
        }
        if (args.length == 3) {
            encoding = args[2];
        }
        try {
            DtausDateiParser p = encoding == null ? new DtausDateiParser(args[0], tol) : new DtausDateiParser(args[0], tol, encoding);
            System.out.println("Anzahl logischer Dateien: " + p.getAnzahlLogischerDateien());
            for (int i = 1; i <= p.getAnzahlLogischerDateien(); ++i) {
                p.setLogischeDatei(i);
                CSatz c = p.next();
                while (c != null) {
                    System.out.println(c);
                    c = p.next();
                }
                System.out.println("----");
                System.out.println(p.getASatz());
                System.out.println(p.getESatz());
                System.out.println("====");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DtausException e) {
            e.printStackTrace();
        }
        System.out.println("Fertig");
    }
}

