/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.PruefziffernCheck;

import de.jost_net.OBanToo.PruefziffernCheck.AccountCRCAlgs;
import de.jost_net.OBanToo.PruefziffernCheck.PZRet;
import java.lang.reflect.Method;

public final class KontoPruefziffernrechnung {
    private static Method getAccountCRCMethodByAlg(String alg) throws Exception {
        Class<AccountCRCAlgs> cl = null;
        Method method = null;
        try {
            cl = AccountCRCAlgs.class;
            method = cl.getMethod("alg_" + alg, int[].class, int[].class);
        }
        catch (Exception e) {
            throw new Exception("CRC algorithm " + alg + " not yet implemented");
        }
        return method;
    }

    public static PZRet checkAccountCRC(String alg, String blz, String number) throws Exception {
        PZRet ret = KontoPruefziffernrechnung.checkAccountCRCByAlg(alg, blz, number);
        return ret;
    }

    public static PZRet checkAccountCRCByAlg(String alg, String blz, String number) throws Exception {
        Method method;
        PZRet ret = null;
        if (blz == null || number == null) {
            throw new NullPointerException("blz and number must not be null");
        }
        if (number.length() <= 10 && (method = KontoPruefziffernrechnung.getAccountCRCMethodByAlg(alg)) != null) {
            try {
                int[] blz_digits = KontoPruefziffernrechnung.string2Ints(blz, 8);
                int[] number_digits = KontoPruefziffernrechnung.string2Ints(number, 10);
                Object[] args = new Object[]{blz_digits, number_digits};
                ret = (PZRet)method.invoke(null, args);
            }
            catch (Exception e) {
                return new PZRet(false, e);
            }
        }
        return ret;
    }

    private static int[] string2Ints(String st, int target_length) {
        int[] numbers = new int[target_length];
        int st_len = st.length();
        for (int i = 0; i < st_len; ++i) {
            char ch = st.charAt(i);
            numbers[target_length - st_len + i] = ch - 48;
        }
        return numbers;
    }
}

