/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.QIF;

import de.jost_net.OBanToo.QIF.QIFBuchung;
import de.jost_net.OBanToo.QIF.QIFException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class QIFDateiParser {
    private Vector<QIFBuchung> buchungen = new Vector();
    private int bi = -1;

    public QIFDateiParser(String filename) throws IOException, QIFException {
        this(new BufferedInputStream(new FileInputStream(filename)));
    }

    public QIFDateiParser(InputStream is) throws IOException, QIFException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        if (!line.startsWith("!Type:Bank")) {
            throw new QIFException("Ung\u00fcltiger Header: ", line);
        }
        QIFBuchung buchung = new QIFBuchung();
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("^")) {
                buchung.add(line);
                continue;
            }
            this.buchungen.addElement(buchung);
            buchung = new QIFBuchung();
        }
    }

    public int getAnzahlBuchungen() {
        return this.buchungen.size();
    }

    public QIFBuchung next() {
        ++this.bi;
        if (this.bi >= this.buchungen.size()) {
            return null;
        }
        return this.buchungen.elementAt(this.bi);
    }
}

