/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.Basislastschrift;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import de.jost_net.OBanToo.Dtaus.HeaderFooter;
import de.jost_net.OBanToo.SEPA.Basislastschrift.Basislastschrift;
import de.jost_net.OBanToo.SEPA.Basislastschrift.Zahler;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.jost_net.OBanToo.Tools.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.JAXBException;

public class Basislastschrift2Pdf {
    public Basislastschrift2Pdf(String sepafile, String pdffile) throws IOException, SEPAException, DocumentException, JAXBException {
        Basislastschrift bl = new Basislastschrift();
        bl.read(new File(sepafile));
        new Basislastschrift2Pdf(bl, pdffile);
    }

    public Basislastschrift2Pdf(Basislastschrift bl, String pdffile) throws IOException, SEPAException, DocumentException {
        Document doc = new Document();
        FileOutputStream out = new FileOutputStream(pdffile);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        doc.setMargins(80.0f, 30.0f, 20.0f, 30.0f);
        doc.addAuthor("OBanToo");
        doc.addTitle("Basislastschrift2PDF");
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        String fuss = "Ausgegeben am " + sdf.format(new Date()) + "           Seite:  ";
        HeaderFooter hf = new HeaderFooter();
        hf.setFooter(fuss);
        writer.setPageEvent((PdfPageEvent)hf);
        doc.open();
        Paragraph pTitle = new Paragraph("SEPA-Basislastschrift-Datei", FontFactory.getFont((String)"Helvetica-Bold", (float)13.0f));
        pTitle.setAlignment(1);
        this.outputHeader(bl, doc);
        PdfPTable table = new PdfPTable(5);
        float[] widths = new float[]{80.0f, 95.0f, 85.0f, 40.0f, 30.0f};
        table.setWidths(widths);
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(0.0f);
        table.addCell(this.getDetailCell("Name", 1, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell("Verwendungszweck", 1, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell("Bankverbindung", 1, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell("Mandat", 1, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell("Betrag", 2, BaseColor.LIGHT_GRAY));
        table.setHeaderRows(1);
        ArrayList<Zahler> zahler = bl.getZahler();
        for (Zahler z : zahler) {
            table.addCell(this.getDetailCell(z.getName(), 0));
            table.addCell(this.getDetailCell(z.getVerwendungszweck(), 0));
            table.addCell(this.getDetailCell(z.getBic() + "\n" + z.getIban(), 0));
            table.addCell(this.getDetailCell(z.getMandatid() + " " + z.getMandatsequence().getTxt() + "\n" + Util.DateTTMMJJJJ(z.getMandatdatum()), 0));
            table.addCell(this.getDetailCell(Util.formatCurrency(z.getBetrag()), 2));
        }
        doc.add((Element)table);
        doc.close();
        out.close();
    }

    private void outputHeader(Basislastschrift bl, Document doc) throws DocumentException, SEPAException {
        PdfPTable table = new PdfPTable(2);
        float[] widths = new float[]{200.0f, 170.0f};
        table.setWidths(widths);
        table.setWidthPercentage(65.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(0.0f);
        table.setHorizontalAlignment(2);
        table.addCell(this.getDetailCell("Name", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(bl.getName(), 0));
        table.addCell(this.getDetailCell("Gl\u00e4ubiger-ID", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(bl.getGlaeubigerID(), 0));
        table.addCell(this.getDetailCell("BIC", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(bl.getBIC(), 0));
        table.addCell(this.getDetailCell("IBAN", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(bl.getIBAN(), 0));
        table.addCell(this.getDetailCell("Erstellungsdatum", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(Util.DateTTMMJJJJ(bl.getCreationDateTime()), 0));
        table.addCell(this.getDetailCell("Anzahl Buchungen", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(bl.getAnzahlBuchungen() + "", 2));
        table.addCell(this.getDetailCell("Kontrollsumme", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(Util.formatCurrency(bl.getKontrollsumme()), 2));
        table.addCell(this.getDetailCell("Message-ID", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(bl.getMessageID(), 2));
        doc.add((Element)table);
    }

    private PdfPCell getDetailCell(String text, int align) {
        return this.getDetailCell(text, align, BaseColor.WHITE);
    }

    private PdfPCell getDetailCell(String text, int align, BaseColor backgroundcolor) {
        PdfPCell cell = new PdfPCell(new Phrase(this.notNull(text), FontFactory.getFont((String)"Helvetica", (float)8.0f)));
        cell.setHorizontalAlignment(align);
        cell.setBackgroundColor(backgroundcolor);
        return cell;
    }

    private String notNull(String text) {
        return text == null ? "" : text;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java -cp ... de.jost_net.OBanToo.Dtaus dtausfile pdffile");
            System.exit(1);
        }
        try {
            new Basislastschrift2Pdf(args[0], args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
        catch (SEPAException e) {
            e.printStackTrace();
            System.exit(3);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            System.exit(4);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            System.exit(5);
        }
    }
}

