/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.Land;

import de.jost_net.OBanToo.SEPA.SEPAException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SEPALand {
    private String kennzeichen;
    private ArrayList<Element> elements;
    private int gesamtlaenge = 4;
    private String bezeichnung;
    private Integer bankidentfierlength;
    private Integer accountlength;
    private String ibansample;

    public SEPALand(String kennzeichen, String bezeichnung, String ibanclass, String ibansample) {
        this.kennzeichen = kennzeichen;
        this.bezeichnung = bezeichnung;
        this.ibansample = ibansample;
        this.elements = new ArrayList();
        StringTokenizer tok = new StringTokenizer(ibanclass, "!nac", true);
        while (tok.hasMoreTokens()) {
            int lae = Integer.parseInt(tok.nextToken());
            this.gesamtlaenge += lae;
            tok.nextToken();
            this.elements.add(new Element(lae, tok.nextToken()));
        }
        this.bankidentfierlength = this.elements.get(0).lae;
        this.accountlength = this.elements.get(1).lae;
    }

    public String getKennzeichen() {
        return this.kennzeichen;
    }

    public String getBezeichnung() {
        return this.bezeichnung;
    }

    public void setBankIdentifierLength(Integer bankidentifierlength) {
        this.bankidentfierlength = bankidentifierlength;
    }

    public Integer getBankIdentifierLength() {
        return this.bankidentfierlength;
    }

    public void setAccountLength(Integer accountlength) {
        this.accountlength = accountlength;
    }

    public Integer getAccountLength() {
        return this.accountlength;
    }

    public void setIBANSample(String ibansample) {
        this.ibansample = ibansample;
    }

    public String getIBANSample() {
        return this.ibansample;
    }

    public boolean check(String iban) throws SEPAException {
        if (iban.length() != this.gesamtlaenge) {
            throw new SEPAException("Ung\u00fcltige L\u00e4nge der IBAN");
        }
        int pos = 3;
        for (Element element : this.elements) {
            for (int i = pos; i <= pos + element.getLaenge(); ++i) {
                char c = iban.charAt(i);
                if (element.isNumeric() && (c < '0' || c > '9')) {
                    throw new SEPAException("Ung\u00fcltiges Zeichen an Position " + i + 1);
                }
                if (element.isAlpha() && (c < 'A' || c > 'Z')) {
                    throw new SEPAException("Ung\u00fcltiges Zeichen an Position " + i + 1);
                }
                if (!element.isCharacter() || c >= 'A' && c <= 'Z' && (c < '0' || c > '9')) continue;
                throw new SEPAException("Ung\u00fcltiges Zeichen an Position " + i + 1);
            }
            pos += element.getLaenge();
        }
        return true;
    }

    private class Element {
        private int lae;
        private String typ;

        public Element(int lae, String typ) {
            this.lae = lae;
            this.typ = typ;
        }

        public int getLaenge() {
            return this.lae;
        }

        public boolean isAlpha() {
            return this.typ.equals("a");
        }

        public boolean isNumeric() {
            return this.typ.equals("n");
        }

        public boolean isCharacter() {
            return this.typ.equals("c");
        }
    }
}

