/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.Ueberweisung;

import de.jost_net.OBanToo.SEPA.BIC;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.jost_net.OBanToo.StringLatin.Zeichen;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;

public class Empfaenger {
    private String bic;
    private String name;
    private String nameorig;
    private String iban;
    private String verwendungszweck;
    private String verwendungszweckorig;
    private BigDecimal betrag;
    private String referenz;
    private static final BigDecimal nu = new BigDecimal("0.00");

    public String getBic() throws SEPAException {
        this.checkBic(this.bic);
        return this.bic;
    }

    public void setBic(String bic) throws SEPAException {
        this.checkBic(bic);
        this.bic = bic;
    }

    private void checkBic(String bic) throws SEPAException {
        new BIC(bic);
    }

    public String getName() throws SEPAException {
        this.checkName(this.name);
        return this.name;
    }

    public String getNameOrig() throws SEPAException {
        this.checkName(this.nameorig);
        return this.nameorig;
    }

    public void setName(String name) throws SEPAException {
        String tmpName = Zeichen.convert(name);
        this.checkName(tmpName);
        this.name = tmpName;
        this.nameorig = name;
    }

    private void checkName(String name) throws SEPAException {
        if (name == null || name.length() == 0 || name.length() > 70) {
            throw new SEPAException("Ung\u00fcltiger Name: " + name);
        }
    }

    public String getIban() throws SEPAException {
        new IBAN(this.iban);
        return this.iban;
    }

    public void setIban(String iban) throws SEPAException {
        new IBAN(iban);
        this.iban = iban;
    }

    public String getVerwendungszweck() throws SEPAException {
        this.checkVerwendungszweck(this.verwendungszweck);
        return this.verwendungszweck;
    }

    public String getVerwendungszweckOrig() throws SEPAException {
        this.checkVerwendungszweck(this.verwendungszweckorig);
        return this.verwendungszweckorig;
    }

    public void setVerwendungszweck(String verwendungszweck) throws SEPAException {
        String tmpVerwendungszweck = Zeichen.convert(verwendungszweck);
        this.checkVerwendungszweck(tmpVerwendungszweck);
        this.verwendungszweck = tmpVerwendungszweck;
        this.verwendungszweckorig = verwendungszweck;
    }

    private void checkVerwendungszweck(String verwendungszweck) throws SEPAException {
        if (verwendungszweck == null || verwendungszweck.length() == 0 || verwendungszweck.length() > 140) {
            throw new SEPAException("Ung\u00fcltiger Verwendungszweck: " + verwendungszweck);
        }
    }

    public BigDecimal getBetrag() throws SEPAException {
        this.checkBetrag(this.betrag);
        return this.betrag;
    }

    public void setBetrag(BigDecimal betrag) throws SEPAException {
        this.checkBetrag(betrag);
        this.betrag = betrag;
    }

    public void checkBetrag(BigDecimal betrag) throws SEPAException {
        if (betrag == null || betrag.compareTo(nu) == -1 || betrag.compareTo(nu) == 0) {
            throw new SEPAException("Ung\u00fcltiger Betrag: " + betrag);
        }
    }

    public void checkFaelligkeit(Date faelligkeit) throws SEPAException {
        if (faelligkeit == null) {
            throw new SEPAException("F\u00e4lligkeit ist null");
        }
    }

    public String getReferenz() {
        if (this.referenz == null) {
            return "NOTPROVIDED";
        }
        return this.referenz;
    }

    public void setReferenz(String referenz) {
        this.referenz = referenz;
    }

    public String toString() {
        String message = "";
        try {
            message = MessageFormat.format("Empf\u00e4nger: Name={0}, IBAN={1}, BIC={2}, Verwendungszweck={3}, Betrag={4}, ", this.getName(), this.getIban(), this.getBic(), this.getVerwendungszweck(), this.getBetrag());
        }
        catch (SEPAException e) {
            message = e.getMessage();
        }
        return message;
    }
}

