/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.Ueberweisung;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.AccountIdentificationSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.ActiveOrHistoricCurrencyCodeEUR;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.AmountTypeSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.BranchAndFinancialInstitutionIdentificationSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.BranchAndFinancialInstitutionIdentificationSEPA3;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.CashAccountSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.CashAccountSEPA2;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.ChargeBearerTypeSEPACode;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.CreditTransferTransactionInformationSCT;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.CustomerCreditTransferInitiationV03;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.Document;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.FinancialInstitutionIdentificationSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.FinancialInstitutionIdentificationSEPA3;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.GroupHeaderSCT;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.PartyIdentificationSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.PartyIdentificationSEPA2;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.PaymentIdentificationSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.PaymentInstructionInformationSCT;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.PaymentMethodSCTCode;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.PaymentTypeInformationSCT1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.RemittanceInformationSEPA1Choice;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_001_003_03.ServiceLevelSEPA;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.jost_net.OBanToo.SEPA.Ueberweisung.Empfaenger;
import de.jost_net.OBanToo.StringLatin.Zeichen;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Ueberweisung {
    private String messageID = null;
    private String bic = null;
    private String iban = null;
    private String name = null;
    private ArrayList<Empfaenger> empfaengerarray = new ArrayList();
    private boolean sammelbuchung = false;
    private BigDecimal kontrollsumme = new BigDecimal(0);
    private String anzahlbuchungen;
    private Date creationdatetime;
    private Date dateofexecution;

    public void add(Empfaenger empfaenger) {
        this.empfaengerarray.add(empfaenger);
    }

    public void setSammelbuchung(boolean sammelbuchung) {
        this.sammelbuchung = sammelbuchung;
    }

    public void write(File file) throws DatatypeConfigurationException, SEPAException, JAXBException, FileNotFoundException {
        this.write(new BufferedOutputStream(new FileOutputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BufferedOutputStream bos) throws JAXBException, DatatypeConfigurationException, SEPAException {
        Document doc = new Document();
        doc.setCstmrCdtTrfInitn(this.getCustumerCreditTransferInitiationV03());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Document.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.schemaLocation", (Object)"urn:iso:std:iso:20022:tech:xsd:pain.001.003.03 pain.001.003.03.xsd");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try {
            m.marshal((Object)doc, (OutputStream)bos);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new SEPAException(e.getMessage());
            }
        }
    }

    private CustomerCreditTransferInitiationV03 getCustumerCreditTransferInitiationV03() throws DatatypeConfigurationException, SEPAException {
        CustomerCreditTransferInitiationV03 cddi = new CustomerCreditTransferInitiationV03();
        for (Empfaenger e : this.empfaengerarray) {
            this.kontrollsumme = this.kontrollsumme.add(e.getBetrag());
        }
        cddi.setGrpHdr(this.getGroupHeader());
        cddi.getPmtInf().add(this.getPaymentInstructionInformationSCT());
        return cddi;
    }

    private GroupHeaderSCT getGroupHeader() throws DatatypeConfigurationException, SEPAException {
        GroupHeaderSCT grH = new GroupHeaderSCT();
        this.creationdatetime = new Date();
        grH.setCreDtTm(Ueberweisung.getYYYMMDDHHMMSS(this.creationdatetime));
        grH.setCtrlSum(this.kontrollsumme);
        PartyIdentificationSEPA1 partyid1 = new PartyIdentificationSEPA1();
        partyid1.setNm(Zeichen.convert(this.getName()));
        grH.setInitgPty(partyid1);
        grH.setMsgId(this.getMessageID());
        grH.setNbOfTxs(this.empfaengerarray.size() + "");
        this.anzahlbuchungen = this.empfaengerarray.size() + "";
        return grH;
    }

    private PaymentInstructionInformationSCT getPaymentInstructionInformationSCT() throws SEPAException, DatatypeConfigurationException {
        PaymentInstructionInformationSCT pii = new PaymentInstructionInformationSCT();
        pii.setBtchBookg(this.sammelbuchung);
        pii.setChrgBr(ChargeBearerTypeSEPACode.SLEV);
        BigDecimal seqKontrollsumme = new BigDecimal(0);
        int seqAnzahl = 0;
        for (Empfaenger e : this.empfaengerarray) {
            seqKontrollsumme = seqKontrollsumme.add(e.getBetrag());
            ++seqAnzahl;
        }
        pii.setCtrlSum(seqKontrollsumme);
        pii.setNbOfTxs(seqAnzahl + "");
        PartyIdentificationSEPA2 pi2 = new PartyIdentificationSEPA2();
        pi2.setNm(Zeichen.convert(this.getName()));
        pii.setDbtr(pi2);
        AccountIdentificationSEPA ai = new AccountIdentificationSEPA();
        ai.setIBAN(this.getIBAN());
        CashAccountSEPA1 ca1 = new CashAccountSEPA1();
        ca1.setId(ai);
        pii.setDbtrAcct(ca1);
        BranchAndFinancialInstitutionIdentificationSEPA3 bafii = new BranchAndFinancialInstitutionIdentificationSEPA3();
        FinancialInstitutionIdentificationSEPA3 fii = new FinancialInstitutionIdentificationSEPA3();
        fii.setBIC(this.getBIC());
        bafii.setFinInstnId(fii);
        pii.setDbtrAgt(bafii);
        pii.setPmtInfId(this.getMessageID());
        pii.setPmtMtd(PaymentMethodSCTCode.TRF);
        pii.setPmtTpInf(this.getPaymentTypeInformationSCT1());
        pii.setReqdExctnDt(Ueberweisung.getYYYMMDD(this.dateofexecution));
        for (Empfaenger e : this.empfaengerarray) {
            pii.getCdtTrfTxInf().add(this.getCreditTransferTransactionInformationSCT(e));
        }
        return pii;
    }

    private static XMLGregorianCalendar getYYYMMDD(Date date) throws DatatypeConfigurationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        XMLGregorianCalendar xmlgc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        xmlGregorianCalendar.setDay(xmlgc.getDay());
        xmlGregorianCalendar.setMonth(xmlgc.getMonth());
        xmlGregorianCalendar.setYear(xmlgc.getYear());
        return xmlGregorianCalendar;
    }

    private static XMLGregorianCalendar getYYYMMDDHHMMSS(Date date) throws DatatypeConfigurationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        XMLGregorianCalendar xmlgc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        xmlGregorianCalendar.setDay(xmlgc.getDay());
        xmlGregorianCalendar.setMonth(xmlgc.getMonth());
        xmlGregorianCalendar.setYear(xmlgc.getYear());
        xmlGregorianCalendar.setHour(xmlgc.getHour());
        xmlGregorianCalendar.setMinute(xmlgc.getMinute());
        xmlGregorianCalendar.setSecond(xmlgc.getSecond());
        return xmlGregorianCalendar;
    }

    private CreditTransferTransactionInformationSCT getCreditTransferTransactionInformationSCT(Empfaenger e) throws SEPAException {
        CreditTransferTransactionInformationSCT ctti = new CreditTransferTransactionInformationSCT();
        AmountTypeSEPA at = new AmountTypeSEPA();
        ActiveOrHistoricCurrencyAndAmountSEPA aohcaa = new ActiveOrHistoricCurrencyAndAmountSEPA();
        aohcaa.setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR);
        aohcaa.setValue(e.getBetrag());
        at.setInstdAmt(aohcaa);
        ctti.setAmt(at);
        PartyIdentificationSEPA2 pis2 = new PartyIdentificationSEPA2();
        pis2.setNm(e.getName());
        ctti.setCdtr(pis2);
        CashAccountSEPA2 ca = new CashAccountSEPA2();
        AccountIdentificationSEPA ai = new AccountIdentificationSEPA();
        ai.setIBAN(e.getIban());
        ca.setId(ai);
        ctti.setCdtrAcct(ca);
        BranchAndFinancialInstitutionIdentificationSEPA1 bafiis = new BranchAndFinancialInstitutionIdentificationSEPA1();
        FinancialInstitutionIdentificationSEPA1 fii = new FinancialInstitutionIdentificationSEPA1();
        fii.setBIC(e.getBic());
        bafiis.setFinInstnId(fii);
        ctti.setCdtrAgt(bafiis);
        PaymentIdentificationSEPA pis = new PaymentIdentificationSEPA();
        pis.setEndToEndId(e.getReferenz());
        ctti.setPmtId(pis);
        RemittanceInformationSEPA1Choice ri = new RemittanceInformationSEPA1Choice();
        ri.setUstrd(e.getVerwendungszweck());
        ctti.setRmtInf(ri);
        return ctti;
    }

    private PaymentTypeInformationSCT1 getPaymentTypeInformationSCT1() {
        PaymentTypeInformationSCT1 pti = new PaymentTypeInformationSCT1();
        ServiceLevelSEPA sls = new ServiceLevelSEPA();
        sls.setCd("SEPA");
        pti.setSvcLvl(sls);
        return pti;
    }

    public void setMessageID(String messageid) throws SEPAException {
        if (messageid == null || messageid.length() == 0 || messageid.length() > 35) {
            throw new SEPAException("Message-ID muss zwischen 1 und 35 Stellen lang sein");
        }
        this.messageID = messageid;
    }

    public String getMessageID() throws SEPAException {
        if (this.messageID == null) {
            throw new SEPAException("Message-ID ist noch nicht gef\u00ef\u00bf\u0153llt");
        }
        return this.messageID;
    }

    public void setBIC(String bic) throws SEPAException {
        if (bic == null || bic.length() != 8 && bic.length() != 11) {
            throw new SEPAException("BIC nicht korrekt gef\u00ef\u00bf\u0153llt");
        }
        this.bic = bic;
    }

    public String getBIC() throws SEPAException {
        if (this.bic == null) {
            throw new SEPAException("BIC ist noch nicht gef\u00ef\u00bf\u0153llt");
        }
        return this.bic;
    }

    public void setIBAN(String iban) throws SEPAException {
        new IBAN(iban);
        this.iban = iban;
    }

    public String getIBAN() throws SEPAException {
        if (this.iban == null) {
            throw new SEPAException("IBAN ist noch nicht gef\u00ef\u00bf\u0153llt");
        }
        return this.iban;
    }

    public void setName(String name) throws SEPAException {
        if (name == null || name.length() == 0 || name.length() > 70) {
            throw new SEPAException("Name des Zahlungsempf\u00ef\u00bf\u0153ngers nicht korrekt gef\u00ef\u00bf\u0153llt");
        }
        this.name = name;
    }

    public String getName() throws SEPAException {
        if (this.name == null) {
            throw new SEPAException("Name des Zahlungsempf\u00ef\u00bf\u0153ngers ist noch nicht gef\u00ef\u00bf\u0153llt");
        }
        return this.name;
    }

    void setKontrollsumme(BigDecimal kontrollsumme) {
        this.kontrollsumme = kontrollsumme;
    }

    public BigDecimal getKontrollsumme() {
        return this.kontrollsumme;
    }

    public String getAnzahlBuchungen() {
        return this.anzahlbuchungen;
    }

    void setAnzahlBuchungen(String anzahlbuchungen) {
        this.anzahlbuchungen = anzahlbuchungen;
    }

    public Date getCreationDateTime() {
        return this.creationdatetime;
    }

    void setCreationDateTime(Date creationdatetime) {
        this.creationdatetime = creationdatetime;
    }

    public Date getAusfuehrungsdatum() {
        return this.dateofexecution;
    }

    public void setAusfuehrungsdatum(Date dateofexecution) {
        this.dateofexecution = dateofexecution;
    }

    public ArrayList<Empfaenger> getZahler() {
        return this.empfaengerarray;
    }
}

